/* This file contains some general stuff for my Sudoku Solver
 * Synchronet door.
 *
 * Author: Eric Oulashin (AKA Nightfox)
 * BBS: Digital Distortion
 * BBS address: digdist.bbsindex.com
 *
 * Date       User              Description
 * 2009-11-09 Eric Oulashin     Created (and moved some stuff over from
 *                              the other .js files).
 * 2009-11-13 Eric Oulashin     Added solveUsingExternal().
 * 2009-11-14 Eric Oulashin     Added fixPathSlashes() and
 *                              solveSudokuPuzzle().
 */

load("sbbsdefs.js");

// Bring in the SudokuSolver class
load(startup_path + "DDSudokuSolverClass.js");

var gSudokuSolverVersion = "1.00";
var gSudokuSolverVersionDate = "2009-11-15";


// Arrow characters
var UP_ARROW_CHAR = "";
var DOWN_ARROW_CHAR = "";
var LEFT_ARROW_CHAR = "";
var RIGHT_ARROW_CHAR = "";

// This function displays general help for the program.
function displayGeneralHelp()
{
   //var gSudokuSolverVersion = "0.90";
   //var gSudokuSolverVersionDate = "2009-11-09";
   console.clear("n");
   console.center("whSudoku Solver");
   console.gotoxy(1, 2);
   console.center("k");
   console.gotoxy(1, 3);
   console.center("ncVersion g" + gSudokuSolverVersion + " wh(b" +
                  gSudokuSolverVersionDate + "w)");
   console.gotoxy(1, 4);
   console.center("ncby Eric Oulashin wh(ncAKA Nightfoxwh)nc, sysop of Digital Distortion BBS");

   console.gotoxy(1, 6);
   console.print("Sudoku is a type of puzzle in which numbers from 1 to 9 must be placed in a 9x9\r\n");
   console.print("grid such that each digit only appears once in each row, column, and 3x3 group\r\n");
   console.print("of cells.\r\n\r\n");
   console.print("This is a program that can be used to solve Sudoku puzzles.  This program uses\r\n");
   console.print("a brute-force algorithm, which should be able to solve any valid Sudoku puzzle.\r\n");
   console.print("The algorithm came from the following Wikipedia page on the web:\r\n");
   console.print("http://en.wikipedia.org/wiki/Algorithmics_of_sudoku\r\n\r\n");
}

// This function solves the puzzle using the external solveSudokuPuzzle
// executable program (assuming there is one).
//
// Return value: A SudokuSolution object containing the puzzle solution.
//               If there is a problem, null will be returned.
function solveUsingExternal()
{
   var retval = null;

   // Open a text file in the node directory and write gSolver's
   // grid values to that file.
   var puzzleFilename = fixPathSlashes(system.node_dir + "sudokuPuzzle.txt");
   var readPuzzleFile = false; // Will be set true if we can read the puzzle file later
   var outFile = new File(puzzleFilename);
   if (outFile.open("w"))
   {
      // Write the grid values from gSolver to the file.
      var textLine = "";
      for (var row = 0; row < 9; ++row)
      {
         textLine = "";
         for (var col = 0; col < 9; ++col)
            textLine += format("%d", gSolver.grid[row][col]);
         outFile.writeln(textLine);
      }
      outFile.close();
      // Run the solveSudokuPuzzle executable to solve the puzzle.
      var execRetval = system.exec(startup_path + "solveSudokuPuzzle " + puzzleFilename);
      // If successful, then we can read in the solution values from the
      // puzzle file.
      readPuzzleFile = (execRetval == 0);
   }

   // If the solver program ran, then read the solution values from the
   // solution file.
   if (readPuzzleFile)
   {
      var inFile = new File(puzzleFilename);
      if (inFile.open("r"))
      {
         retval = new SudokuSolution();

         // Read the solved puzzle values into retval
         var row = 0;
         var fileLine = "";
         while (!inFile.eof)
         {
            fileLine = inFile.readln();

            // fileLine should be a string, but I've seen some cases
            // where it isn't, so check its type.
            if (typeof(fileLine) != "string")
               continue;
            // Also, the file line should have 9 characters.
            if (fileLine.length < 9)
               continue;

            for (var col = 0; col < 9; ++col)
            {
               //gSolver.grid[row][col] = +(fileLine.charAt(col));
               retval.grid[row][col] = +(fileLine.charAt(col));
            }
            ++row;
         }

         inFile.close();
      }
   }

   // Delete the puzzle file
   file_remove(puzzleFilename);

   return retval;
}

// Fixes the slashes in a path to make them all consistent.  Returns
// a copy of the fixed string.
//
// Parameters:
//  pPathStr: A file path (string)
//
// Return value: The fixed path string
function fixPathSlashes(pPathStr)
{
   var pathStr = pPathStr;
   // If on Windows, replace / with \.  If on Linux, replace \ with /.
   if (/^WIN/.test(system.platform.toUpperCase()))
   {
      while (pathStr.indexOf("/", 0) > -1)
         pathStr = pathStr.replace("/", "\\");
   }
   else
   {
      while (pathStr.indexOf("\\", 0) > -1)
         pathStr = pathStr.replace("\\", "/");
   }
   return pathStr;
}

// Solves the Sudoku puzzle, using the external solver if available
// or the gSolver object if not.
function solveSudokuPuzzle()
{
   // If a solveSudokuPuzzle executable exists, then use it to solve
   // the puzzle.  Otherwise, use gSolver to solve the puzzle.
   if (file_exists(startup_path + "solveSudokuPuzzle*"))
   {
      var solvedGrid = solveUsingExternal();
      if (solvedGrid != null)
      {
         for (var myRow = 0; myRow < 9; ++myRow)
         {
            for (var myCol = 0; myCol < 9; ++myCol)
            {
               gSolver.solutions = new Array();
               gSolver.solutions[0] = solvedGrid;
            }
         }
      }
   }
   else
      gSolver.solve();
}